<?php
//controller advocateAtOffice
class AdvocateAtOfficeController extends Controller{
	public $name= 'advocateAtOffice';
	public $images = 5;
	public $set = 'advocateAtOffice';

	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'AdvocateAtOffice_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		include ('view/header.php');
		include ('view/preview.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='advokatni-kancelare';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='advocate-at-office';
		}
		
		$ret .= '/';
		return $ret;
	}
}
