<?php
class CaseStudiesController extends Controller{
	public $name = 'caseStudies';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'CaseStudies_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		if(isset($_POST['submit'])){
			$body = 'jmeno: '.strval($_POST['name']).PHP_EOL;
			$body .= 'email: '.strval($_POST['email']).PHP_EOL;
			$this->other->infoText = 'Děkujeme za Váš zájem o produkt Task Manager';
			$this->sendMail('Pripadova studie', $body);
		}
	
		include ('view/header.php');
		include ('view/default.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='task-manager-pripadove-studie';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='taskmanager-case-studies';
		}
		
		$ret .= '/';
		return $ret;
	}

}
