<?php
//controller contacts
class ContactsController extends Controller{
	public $name = 'contacts';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'Contacts_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		if(isset($_POST['submit'])){
			$body = 'Jmeno: '.strval($_POST['name']).PHP_EOL;
			$body .= 'Spolecnost: '.strval($_POST['company']).PHP_EOL;
			$body .= 'E-mail: '.strval($_POST['email']).PHP_EOL;
			$body .= 'Telefon: '.strval($_POST['telephone']).PHP_EOL;
			$body .= 'Zprava: '.strval($_POST['note']).PHP_EOL.PHP_EOL;
			$body .= 'Pozice: '.strval($_POST['position']).PHP_EOL.PHP_EOL;
			$body .= '$_SERVER:'.PHP_EOL.print_r($_SERVER,1);
			
			$this->other->infoText = 'Vaše zpráva byla úspěšně odeslána. Děkujeme za Váš zájem o produkt TaskManager';
			$this->sendMail('taskmanager.cz: pozadavek na kontakt', $body);
		}
		
		include ('view/header.php');
		include ('view/default.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='kontaktujte-it-park';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='contact-it-park';
		}
		
		$ret .= '/';
		return $ret;
	}
}
