<?php
//controller developmentTeam
class DevelopmentTeamController extends Controller{
	public $name= 'developmentTeam';
	public $images = 5;
	public $set = 'developmentTeam';

	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'DevelopmentTeam_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		include ('view/header.php');
		include ('view/preview.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='vyvojove-tymy';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='development-teams';
		}
		
		$ret .= '/';
		return $ret;
	}
}
