<?php
class HelpdeskController extends Controller{
	public $name = 'helpdesk';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'Helpdesk_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		if(isset($_POST['submit'])){
			$body = 'Jmeno: '.strval($_POST['name']).PHP_EOL;

			$body .= 'E-mail: '.strval($_POST['email']).PHP_EOL;
			$body .= 'Zakaznicke cislo: '.strval($_POST['number']).PHP_EOL;

			$body .= 'Problem: '.strval($_POST['note']).PHP_EOL.PHP_EOL;
			$body .= '$_SERVER:'.PHP_EOL.print_r($_SERVER,1);

			if( intval($_POST['antispam']) == 5){
				$this->other->infoText = 'Váš požadavek byl odeslán.';
				$this->sendMail('taskmanager.cz: Helpdesk', $body);
			}else{
				$this->other->infoText = 'Špatný výsledek antispam!';
			}
		}
	
	
		include ('view/header.php');
		include ('view/default.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='taskmanager-hotline';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='taskmanager-hotline';
		}
		
		$ret .= '/';
		return $ret;
	}
}
