<?php
//controller news
class NewsController extends Controller{
	public $name = 'news';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'News_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getJson
	* load data and parse to json
	*/
	public function getJson(){
		header('Content-type: application/json');
		$return['news'] = array();
		foreach( $this->lang->news as $tmp){
			$ret['title'] = $tmp[0];
			$ret['text'] = $tmp[1];
			$ret['date'] = $tmp[2];
			$return['news'][] = $ret;
		}
		echo json_encode($return);
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='novinky';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='news';
		}
		
		$ret .= '/';
		return $ret;
	}
}
