<?php
class PriorityHelpdeskController extends Controller{
	public $name = 'priorityHelpdesk';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'PriorityHelpdesk_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		include ('view/header.php');
		include ('view/default.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='prioritni-podpora-uzivatelu-task-managera';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='priority-helpdesk-for-taskmanager-users';
		}
		
		$ret .= '/';
		return $ret;
	}
}
