<?php
//controller realEstate
class RealEstateController extends Controller{
	public $name = 'realEstate';
	public $images = 5;
	public $set = 'realEstate';

	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'RealEstate_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		include ('view/header.php');
		include ('view/preview.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='realitni-kancelare';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='real-estates';
		}
		
		$ret .= '/';
		return $ret;
	}
}
