<?php
class aboutProduct_en{
	public $title = 'About TaskManager';
	public $description = 'TaskManager – simple solution for task management and time managermen, supporting internal company processes';
	public $keywords = 'TaskManager, manager task management time, lean management, effectivity boosting';

	public $text = '
<p>
The TaskManager solution is the flagship of IT Park s.r.o. Its first idea was based on the practice of some of our staff in other organizations. In their work, they felt a lack of opportunities to manage the efficiency of their work or the work of their subordinates. They called for an effective task management tool that would be easily interconnected with customers (and could serve therefore as a help desk), easy to control and allow prioritization of tasks - exactly in line with the theory and practice of <a href="{timeManagement}" title="time management III">3rd generation time management</a>.
</p>

<p>
TaskManager has already gone through a number of <a href="{changeLog}" title="updates">updates</a>,  extensions and completing new features (and new enhancements are still underway). Nowadays it is one of the few purely Czech solutions for the area of so-called <a href="{taskManagement}" title="task management">task management</a>, which is task management in line with <a href="{timeManagement}" title="time management 3rd generation">3rd generation time management</a>.
</p>

<p>
In which areas can TaskManager be right at hand for you?
</p>

<h2>From the management perspective, it allows:</h2>

<ul>
    <li>If needed, simply define, plan and manage the roles of their subordinates or members of the implementation or project team.</li>
    <li>If needed, keep an eye on the cost-effectiveness and efficiency of individual workers.</li>
    <li>If needed, keep an overview of the status of the individual projects, the problems of the accompanying projects, the workers involved in the project and their performance, and so on. The TaskManager tool is also suitable as a support solution for project managers.</li>
    <li>If needed, estimate the time and possible obstacles to complete tasks towards higher management or customers.</li>
    <li>If needed, use a shared calendar and bulk notifications for certain actions or events without having to send bulk emails or call an informative meeting.</li>
    <li>If needed, have an overview of the completeness of each task. (in this case, TaskManager offers compendious graphic processing that will show you the state of individual tasks at first sight.)</li>
    <li>If needed, support the introduction of <a href="{leanManagement}" title="lean management">lean management</a> in your company, department, or project team with appropriate software.</li>
</ul>

<h2>From the point of view of staff, it allows:</h2>

<ul>
    <li>If needed, report to your supervisor on the status and results of your work in the fastest and easiest possible way that will not unnecessarily drive you away from further work.</li>
    <li>If needed, have an overview of all the projects and orders - and (above all) the tasks that result from these orders for you.</li>
    <li>If needed, assign tasks to other workers in a simple and efficient way.</li>
    <li>If needed, communicate effectively with your clients with respect to semi-finished orders.</li>
</ul>

<br />

<p>
We continuously monitor the needs of both management and implementation staff in various industries, and we are adjusting TaskManager solutions based on these surveys. Our goal is that TaskManager is as flexible as you already are or need to be. 
</p>

<p> 
If you are interested in viewing and testing the TaskManager solution environment, use <a href="{trialVersion}" title="registration form">the registration form to get the demo version</a>.
</p>

<div class="links">
	<h2>Kam dál</h2>

	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="vlastnosti">Podívejte se na vlastnosti a přednosti řešení TaskManager</a></li>
		<li><a href="{functions}" title="funkce" >Podívejte se na přehled funkcí, díky kterým je TaskManager optimálním řešením pro malé i velké týmy</a></li>
		<li><a href="{references}" title="reference">Zjistěte, kdo již řešení TaskManager využívá</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o demoverzi</a></li>
	</ul>
</div>
';
}
