<?php
class Faq_en{
	public $title = 'FAQ';
	public $description = 'Nejčastější dotazy k řešení TaskManager určenému pro řízení úkolů, time management či project management.';
	public $keywords = 'TaskManager, manager task management time, času řízení úkolů';

	public $text = '
<H2>1. What is SaaS?</H2>
<P>
SaaS is an acronym expressing Software as a Service. You do not have to buy the software offered under this type of license. It is operated on the technical equipment of the provider, which normally provides all operational matters, takes care of updating the system, etc. Apps provided as a service are often accessible from the Internet. You have the advantage that they are available from anywhere where you can connect to the internet. For such software, you generally pay a lump sum (monthly, quarterly, yearly) for the provision of such a service. This system has several advantages. The most prominent of them is obviously the fact that you do not have to worry about running the software and ensuring the employee responsible for managing it. This question belongs to the software provider\'s competence in SaaS mode and you only use software with no such worries.</P>

<H2>2. What are the differences between the user account and the admin account?</H2>
<P>
The Admin account, as its name suggests, serves primarily to administer the app and manage the rights of other users who have access to the app. It has several tools that are not available to regular users, such as:
</P>
<UL style="margin:10px;">
	<LI>setting user rights in relation to the TaskManager application,</li>
	<LI>setting user rights in relation to individual projects,</li>
	<LI>managing the resources available in the application,</li>
	<LI>setting certain attributes for system behaviour,</li>
	<LI>checking the sent urgent SMS messages,</li>
	<LI>managing task types and so on.</li>
</UL>
<P> Managing these features is more demanding than just using an app by a regular user. That\'s why we\'ve prepared a dedicated <a href="{adminTraining}">TaskManager Administrator training</a>. There is a <a href="{userTraining}">user training for regular users</a> too, where you will learn the basics and best practices in task management, time management directly in TaskManager.</p>

<H2>3. What makes TaskManager so unique?</H2>
<P>The TaskManager solution has several advantages that make it significantly different from competing products. These are primarily the following:</P>
<UL style="margin:10px;">
	<LI>All important features are implemented in one place, in one application. This way you do not have to use five different programs to manage your work performance effectively.</li> 
	<LI>TaskManager contains a time tracker for measuring time. You do not have to use any external applications again. TaskManager allows you to measure the time you spend and then report it in the reports.</li> 
	<LI>The TaskManager application is multiplatform. With web-based access, you can connect to all commonly available devices such as PCs, laptops, tablets, smartphones, and some common mobile phones with mobile internet browsers.</li> 
	<LI>TaskManager has a user-friendly and intuitive user environment that everyone can use. In its development, we have taken utmost care to ensure usability and maximum ease of use. You do not have to waste time fighting the app or one of its features, and you can use TaskManager to the fullest.</li> 
</UL>

<H2>4. How can I order this solution?</H2>
<P>If you are interested in presenting TaskManager solutions or you want to order them directly, please contact us at e-mail address <A HREF="mailto:obchod@itpark.cz">obchod@itpark.cz</A>, or fill out the <a href="{contacts}">contact form</a>. If you use e-mail address <A HREF="mailto:obchod@itpark.cz">obchod@itpark.cz</A>, please also include a telephone contact to you in the e-mail so that we can contact you by phone to speed up our communication.</P>

<H2>5. How can I contact support?</H2>
<P>If you are our client, the TaskManager user, you were pretty much aware of the email addresses or phone numbers to contact support. Your options for contacting technical support also depend on how you have prepaid support access to helpdesk. If you do not have these contacts, you can always use the <a href="http://taskmanager.cz/helpdesk/">online helpdesk</a>.</P>

<H2>6. For which businesses is TaskManager best suited?</H2>
<P>TaskManager is a multi-business solution that can be used both in the service sector and in manufacturing businesses. A simple criterion is whether the individual organizational levels of your company need to communicate effectively and assign tasks in a way that allows them to monitor their performance and evaluate the effectiveness of their work. If this condition is met, then TaskManager is the right solution for you.</P>

<H2 >7. What are the technical requirements if I want to buy a TaskManager solution (on-premise licence)?</H2>
<P>
You can buy TaskManager in two ways. In the form of SaaS (Software as a Service), when you do not have to worry about computer or server hardware (automatically scaling HW servers to meet the high requirements of our clients) or you can obtain a TaskManager license - in this case it is installed directly on the server to your company. In this case, however, it is necessary to ensure that the parameters of such a server are sufficient for the smooth operation of TaskManager. Server requirements vary according to the number of users who work with TaskManager. The following table contains recommended hardware for different user counts:</P>
<br />
<table style="border-width:1px; border-style:solid; border-color:#888; margin-left:20px; margin-right:20px;">
	<tr>
		<th style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">Number of users</th>
		<th style="border-width:0px 0px 1px 0px; border-style:solid; border-color:#888; padding:4px;">Recommended HW configuration of server</th>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 5
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Celeron 2.6GHz<br />
			RAM: 2 GB<br />
			HDD: 7200rpm<br />
			Network: at least 10Mbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 25
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Core 2 Q9650 Quad Core, 3GHz, 1333FSB, 12MB cache<br />
			RAM: 4 GB<br />
			HDD: 7200rpm<br />
			Network: at least 100Mbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 100
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Core 2 Q9650 Quad Core, 3GHz, 1333FSB, 12MB cache<br />
			RAM: 4 GB<br />
			HDD: 10000rpm or SSD<br />
			Network: 1Gbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 0px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 1000
		</td>
		<td style="padding:4px;">
		For environments with such a large number of users, we recommend that you deploy the TaskManager on the HP Proliant mid-range server, such as (Two-processor server HP ProLiant DL360G7 rack 1U, Quad-Core Intel Xeon E5630, RAM 6GB DDR3, without HDD, RAID (0/1/1+0/5/5+0)), Network connection of the server: 1Gbit
		<td>
	</tr>
</table>
<br />

<H2>8. What does LDAP / AD mean?</H2>
<P >
LDAP stands for Lightweight Directory Access Protocol. It is a protocol that is used to save users and their data (name, surname, login, password, e-mail, access card number, ...). In a simple way, we can imagine that this is a directory that lists other details, such as login and password, besides the username. TaskManager can use it in the sense that it does not need to create a new user, but just configure it to authenticate the user to LDAP, and then any change that is made to the LDAP is immediately projected into TaskManager.
AD means Active Directory is the implementation of LDAP directory services by Microsoft.
</P>

<H2>9. How many users can use the TaskManager solution if I buy a on-premise license?</H2>
<P ><B>The TaskManager on-premise license is not limited by the number of users.</B> The only factor that determines the number of users is the performance of your hardware on which TaskManager will run. It is important to remember that with a large number of users, TaskManager\'s hardware requirements are increasing. </P>

<H2>10. Is it necessary to always enter TaskManager app to create new tasks?</H2>
<P>No, it\'s not. You can just enter the TaskManager task when you send an e-mail message in the right form. In this way, you can also attach attachments that are saved in TaskManager to the created tasks. Since most of the mobile phones already have an email client, you are not bound by the computing technique when assigning tasks.</P>

<H2>11. Is it possible to reject task in TaskManager?</H2>
<P>
Rejection of the task is usually done by the worker who receives the task to solve by his commentary (negative) and then either moves the task to group Completed or, if created by admin, in the new group Rejected. The task assignor of course, receives an email notification both when changing the task group and writing a comment on the task so that he learns about it and can take further steps.</P>

<H2>12. How is it with pending tasks?</H2>
<P>
Pending tasks are tasks currently inactive and the tasks for some reason suspended. Practice shows that although the assignor has a task assigned to the worker and he partially fulfils it, sometimes, for example, he needs to work with the other party (for example with the customer - the worker asks for more information and awaits their receipt), so in this case when a worker waits for response from another party, he typically moves the task to pending group, so other worker would not lose time with this task and can continue to perform another one.</P>

<H2>13. How is the completed task accepted by the task author/requestor/assignor?</H2>
<P>
This is typically done by worker completing the task, for example, by writing a comment with a solution or an attachment file, etc., and then moving the task to the Completed group. The assignor is informed about it by e-mail (with a direct link to the task) and the output of the task is taken / checked by him. If he does not like it or disagrees with completion, he can simply add a comment and move the task back to the new tasks, so it appears again in the queue of tasks (the worker will receive an email notification again).
</P>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{aboutProduct}" title="o produktu">Podívejte se na základní informace o řešení TaskManager</a></li>
		<li><a href="{features}" title="přednosti">Prohlédněte si přednosti řešení TaskManager</a></li>
		<li><a href="{functions}" title="funkce">Zjistěte více informací o funkcích řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o demoverzi</a></li>
	</ul>
</div>

';
}
