<?php
class Functions_en{
	public $title = 'Funkce řešení Task Manager';
	public $description = 'Přehled funkcí českého špičkového systému TaskManager pro řízení úkolů – task management, využitelného i pro project či time management. ';
	public $keywords = 'TaskManager, manager task management, prioritizace úkolů, time tracker, reporting, kalendář';

	public $text = '
<h2>Správce úkolů</h2>
<img src="/tmpage/img/function/f_spravce_ukolu.jpg" alt="spravce ukolu" class="">
<br><br>
<p>
Správce úkolů je patrně nejpoužívanější částí aplikace TaskManager. Díky němu máte přehled o všem, co se kolem zadaných úkolů děje. Můžete sledovat jejich rozpracovanost, měnit jejich priority, prohlížet si detaily, přiložené soubory či diskusi, sledovat odpracovaný čas a čas celkově plánovaný (předikovaný) pro splnění úkolu. 
</p>

<p>
Můžete využít pokročilé filtrace u velkého množství sloupců v seznamu úkolů. Filtrovat můžete podle projektů, podle typu úkolu, podle zadavatele či realizátora úkolu apod. Potřebujete se podívat pouze na úkoly spojené s konkrétním projektem? Pro TaskManager žádný problém. Potřebujete si u tohoto projektu vyfiltrovat jen práci konkrétních uživatelů? Stačí pár kliknutí, a je to.
</p>

<p>
U všech sloupců v seznamu úkolů můžete využít dvě možnosti řazení záznamů – vzestupně a sestupně. Tuto možnost oceníte například u řazení úkolů dle data splnění (od nejurgentnějších po nejméně urgentní) či v případě nastavených priorit. Stačí jedno či dvě kliknutí na název sloupce a data máte seřazená dle svých potřeb. Jednodušší už to být nemůže.
</p>



<h2>Prioritizace</h2>
<img src="/tmpage/img/function/prioritizace.jpg" alt="prioritizace" style="float:left; margin-right:15px;">
<p>
Síla řešení TaskManager tkví mimo jiné v možnosti <b>prioritizace úkolů</b>. Teprve díky ní se TaskManager stává opravdu silným nástrojem pro <a href="{taskManagement}" title="task management">Task Management</a> či <a href="{timeManagement}" title="timemanagement III. generace">Time Management III. generace</a>. Při tvorbě řešení TaskManager máme stále na mysli, že úkoly mají různou důležitost, a to jak v pracovním, tak v osobním životě. Abyste měli možnost určovat, co je třeba udělat nejdříve a bez čeho se nějaký čas obejdete, zadávejte prioritu hned při tvorbě každého úkolu. Jednoduše, díky pár kliknutím myši…
</p>

<p>
V aplikaci TaskManager máte na výběr až 9 hodnot důležitosti od stupně „Urgentní“ po stupeň „Nejnižší priorita“. Máte tak k dispozici dostatečně <b>širokou škálu pro prioritizaci</b>, díky níž budete schopni rozlišit nejmenší detaily v důležitosti vytvářených úkolů. Jednoduše řečeno – jsme si vědomi faktu, že 3 stupně priorit vycházející <b>z modelu ABC</b> mnohdy nedostačují. Nepřizpůsobujte své potřeby manažerským modelům. Přizpůsobte manažerské modely svým potřebám.<b>TaskManager je zde pro to, abyste mohli zůstat maximálně flexibilní ve všech oblastech plánování a řízení. TaskManager je tak flexibilní, jak flexibilní jste Vy.</b>
</p>

<br>
<h2>Evidence rozpracovanosti úkolů</h2>
<img src="/tmpage/img/function/evidence_rozpracovanosti.jpg" alt="evidence rozpracovanosti" style="float:right; margin-left:15px; height:200px;">
<p>
K čemu by Vám byl systém pro řízení úkolů, kdybyste neměli možnost sledovat stav rozpracovanosti u každého z nich. S TaskManagerem je sledování stavu jednotlivých úkolů hračkou. Díky barevnému rozlišení jednotlivých úrovní rozpracovanosti (od 0% do 100%) Vám stačí pohledem přelétnout jediný sloupec ve výpisu úkolů, abyste věděli, jak na tom jednotlivé úkoly jsou. Jednotlivé barvy byly pro TaskManager voleny tak, aby od sebe byly snadno rozeznatelné, ale zároveň vyjadřovaly určitou logickou posloupnost. Díky tomu se ve stavech rozpracovanosti zorientujete opravdu rychle.
</p>

<p>
Chcete změnit stav rozpracovanosti určitého úkolu? Stačí jediný klik na příslušné okénko a stav je nastaven. Potřebujete úkol úplně ukončit? Opět je postup maximálně jednoduchý. Klepněte na políčko na úrovni 100%. Po potvrzení hlášení o ukončení úkolu je vše hotovo. Snadněji už to nejde.
</p>

<h2>Time tracker</h2>
<img src="/tmpage/img/function/timetracker.jpg" alt="timetracker" style="float:left; margin-right:15px; margin-bottom:15px;">
<p>
Chcete-li vědět, jak dlouhou dobu trávíte u určitého úkolu, nemusíte sledovat hodiny na Vašem monitoru a pamatovat si čas začátku a ukončení práce. Není třeba používat stopky na mobilu. Nemusíte si zapisovat odpracovaný čas na papír či do excelu. Do aplikace TaskManager jsme pro tyto účely zabudovali jednoduchý <b>time tracker</b>, s jehož pomocí získáte základní informace o odpracovaném času. 
</p>

<p>
Jedním klikem na tlačítko „Play“ <b>time tracker</b> jednoduše spustíte. Poté můžete práci na úkolu buď zcela ukončit (tlačítko „Stop“) nebo pouze přerušit (tlačítko „Pause“). Budete tak mít vždy dokonalý přehled o tom, kolik času na každém úkolu strávíte.
</p>

<p>
<b>Time tracker</b> aplikace TaskManager však nabízí ještě jednu výjimečnou funkci. Pracujete-li na nějakém úkolu, přičemž musíte na chvíli řešit úkol jiný, stačí na druhém úkolu klepnout na tlačítko „Play“. U původně rozpracovaného úkolu se počítání času automaticky přeruší. Můžete se tak plně věnovat novému úkolu, aniž byste si museli zatěžovat hlavu s tím, jestli Vám běží time tracker u úkolu původního. 
</p>

<p>
Užívejte si intuitivního a jednoduchého záznamu odpracovaného času. S <b>time trackerem</b> aplikace TaskManager odpadnou zbytečné mezikroky, které Vás zdržují skutečné práce.
</p>

<h2>Analytické nástroje a statistiky</h2>
<img src="/tmpage/img/function/analyticke_nastroje_statistiky.jpg" alt="analyticke_nastroje_statistiky" style="float:left; margin-right:15px; height:200px;" class="zoom">
<p>
Potřebujete-li vědět, jak jste na tom Vy či Vaši podřízení s efektivností práce, máte v rámci řešení TaskManager k dispozici <b>řadu statistik</b>, které Vám s tím pomohou.
</p>

<p>
Sledovat můžete například, jaké typy úkolů převládají (typy úkolů si můžete definovat sami – například marketing, účetnictví, programování, webdesign apod. Počet typů úkolů je omezen pouze Vaší představivostí a potřebami.), počet úkolů ukončených po termínu, průměrný počet odpracovaných hodin apod.
</p>

<p>
Neustále tak vidíte výsledky své práce či práce Vašich podřízených a můžete se ihned rozhodnout, co je třeba dělat jinak, lépe či kde jsou sledované výsledky excelentní a zasloužily by si třeba zohlednit odměnou. TaskManager se tak stává skutečnou podporou řízení a snah o maximální efektivitu.
</p>

<br>
<h2>Reporting</h2>
<img src="/tmpage/img/function/reporting.jpg" alt="reporting"><br><br>
<p>
Vyžaduje se ve Vaší společnosti pravidelný reporting aktivit? Znamená pro Vás tato aktivita zbytečné mrhání časem spojené s vypisováním excelovské tabulky a lovením v paměti, co jste kdy, kde a proč dělali? S TaskManagerem můžete nyní klidně spát. Žádné podobné noční můry již nenastanou.
</p>

<p>
Jsme si vědomi faktu, že pro manažery je reporting svým způsobem nutností. Víme také, že pro realizační pracovníky se jedná o nutné zlo, které znamená odvádění pozornosti od důležité práce. 
</p>

<p>
Proto jsme do TaskManagera zabudovali automatický reporting, který Vám umožní během pár minut a kliknutí myši vytvořit export Vašich aktivit (nebo aktivit Vašich zaměstnanců). Již žádné vypisování tabulek a formulářů, stačí pouze pár kliknutí a můžete odesílat report se všemi důležitými informacemi. Reporting nebyl nikdy jednodušší!
</p>


<h2>Kalendář</h2>
<img src="/tmpage/img/function/kalendar.jpg" alt="kalendar" style="float:left; margin-right:15px; height:200px;" class="zoom">
<p>
Další pro systém pro plánování času či úkolů typickou funkcí je <b>kalendář</b>. Bez něj se žádná kvalitní manažerská aplikace neobejde.
</p>

<p>
I TaskManager obsahuje <b>jednoduše ovladatelný kalendář</b>, v němž můžete evidovat své schůzky, porady či obědové pauzy. Na výběr jsou typicky denní, týdenní a měsíční pohled, které Vám nabídnou potřebnou úroveň detailů.
</p>

<p>
Při přidávání úkolů můžete zároveň zadat, které ze zdrojů dostupných ve Vaší společnosti (služební automobil, PC/video/audio technika či např. zasedací místnost) pro realizaci události v kalendáři potřebujete.  Máte tak možnost rezervovat si je předem a předejít nemilým překvapením, které naruší plnění Vašich úkolů.
</p>

<br>
<h2>Správce projektů</h2>
<img src="/tmpage/img/function/spravce_projektu.jpg" alt="spravce projektu"><br><br>
<p>
Ať už potřebujete spravovat jeden či desítky projektů, určitě v TaskManagerovi využijete <b>správce projektů</b>. Díky němu můžete sledovat, jaké projekty se aktuálně řeší, kolik a jakých lidí je do nich zapojeno a v případě potřeby měnit jednotlivé atributy u zvolených projektů. Můžete přidávat či ubírat řešitele, měnit termíny pro dokončení projektu a podobně.
</p>

<p>
Jednoduše a díky jediné aplikaci – aplikaci TaskManager tak budete mít neustálý přehled o dění ve společnosti, oddělení či týmu. 
</p>

<h2>Správce uživatelů</h2>
<img src="/tmpage/img/function/spravce_uzivatelu.jpg" alt="spravce uzivatelu"><br><br>
<p>
Samozřejmostí pro řešení typu TaskManager je přehledný a jednoduše ovladatelný <b>správce uživatelů</b>. Neomezujte se a buďte tak dynamičtí, jak dynamické jsou Vaše projekty. Díky správci uživatelů můžete libovolně přidávat či ubírat uživatele, měnit jejich práva pro práci v aplikaci TaskManager a mnoho dalšího. Získáte tak plnou kontrolu nad uživateli systému a jejich přístupy k datům, která potřebují pro svou práci.
</p>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="funkce">Prohlédněte si hlavní výhody řešení TaskManager.</a></li>
		<li><a href="{references}" title="reference">Zjistěte, kdo již řešení TaskManager využívá</a></li>
		<li><a href="{tutorials}" title="řešení taskmanager">Podívejte se, jak vypadá prostředí řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o demoverzi</a></li>
	</ul>
</div>

';
}
