<?php

//Controller (main)
class Controller{
	protected $lang;
	protected $other;

	/**
	* @method __construct
	* Load other language pack
	*/
	public function __construct( $lang = 'cs'){
		$class = 'Other_'.$lang;
		$this->other = new $class;
		error_log('class='.$class);
	}

	/**
	* @method getLink
	* generate link
	*/
	public function getLink( $action = 'taskmanager', $lang ='cs'){
		if( 'http' != substr($action,0,4)){
			return BASE_PATH.$lang.'/'.$action.'/';
		}else{
			return $action;
		}
	}
	
	/**
	* return link for template
	* @param $action key in url
	* @return string (link)
	*/
	private function getLinkTemplate($action){
		$act = substr($action[0],1,-1);
		$link = $this->other->url[$act][0];
		//$name = $this->other->url[$act][1];
		return $href = $this->getLink($link, $this->other->lang);
		//return '<a href="'.$href.'" title="'.$name.'">'.$name.'</a>';
	}

	/**
	* function for chnage string like {action} to <a href=""..>..
	*/
	public function template($text){
		return preg_replace_callback('{{[a-z,A-Z]+}}','Controller::getLinkTemplate',$text);
	}
	
	/**
	* send mail
	* @param string subject
	* @param string body
	*/
	protected function sendMail($subject = 'email', $body ='email'){
		$to = EMAIL;
		mail($to, $subject, $body, "From: taskmanager@itpark.cz");
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			//in this case REWRITE (not append) $ret
			$ret='http://taskmanager.cz';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='taskmanager';
		}
		
		$ret .= '/';
		return $ret;
	}
}
