<?php
class TrialVersionController extends Controller{
	public $name = 'trialVersion';
	/**
	* @method __construct
	* Load lang language pack
	*/
	public function __construct( $lang ){
		parent::__construct($lang);	//load other
		$class = 'TrialVersion_'.$lang;
		$this->lang = new $class;
	}

	/**
	* @method getHtml
	* load template
	*/
	public function getHtml(){
		if(isset($_POST['submit'])){

			$body = 'Jmeno: '.strval($_POST['name']).PHP_EOL;
			$body .= 'Spolecnost: '.strval($_POST['company']).PHP_EOL;
			$body .= 'Funkce: '.strval($_POST['position']).PHP_EOL;
			$body .= 'Web: '.strval($_POST['web']).PHP_EOL;
			$body .= 'E-mail: '.strval($_POST['email']).PHP_EOL;
			$body .= 'Telefon: '.strval($_POST['telephone']).PHP_EOL;
		//	$body .= 'Telefon. hod.: '.strval($_POST['telephoneTime']).PHP_EOL;
			$body .= 'Sdeleni: '.strval($_POST['note']).PHP_EOL;
			if($_POST['learnAboutUs'] == 'other'){
				$body .= 'Dozvedeli se o nas z: '.strval($_POST['textOther']).PHP_EOL;
			}else{
				$body .= 'Dozvedeli se o nas z: '.strval($_POST['learnAboutUs']).PHP_EOL;
			}
			$body .= PHP_EOL;
			$body .= '$_SERVER:'.PHP_EOL.print_r($_SERVER,1);
			
			if(isset($_POST['antispam']) && strval($_POST['antispam'])=='8'){
				$this->other->infoText = 'Vaše zpráva byla úspěšně odeslána. Děkujeme za Váš zájem o produkt TaskManager';
				$this->sendMail('taskmanager.cz: zajem o zkusebni verzi TaskManageru', $body);
			}
			else{
				$this->other->infoText = 'Nesprávná odpověď na kontrolní otázku!';
			}
		}
	
		include ('view/header.php');
		include ('view/default.php');
		include ('view/footer.php');
	}
	public function getLocalizedUrl($lang){
		$ret = BASE_PATH.$lang.'/';
		if($lang == 'cs'){
			$ret.='task-manager-zkusebni-verze';
		}
		elseif($lang == 'nl'){
			$ret.='';
		}
		else{ //en and other languages
			$ret.='taskmanager-trial-version';
		}
		
		$ret .= '/';
		return $ret;
	}
}
