<?php
class aboutProduct_cs{
	public $title = 'O řešení TaskManager';
	public $description = 'TaskManager – špičkové české řešení určené zejména pro task management – správu úkolů. Využitelné je i pro řízení času (time management) či projektů (project management).';
	public $keywords = 'TaskManager, manager task management time, lean management, řízení efektivnosti';

	public $text = '
<p>
Řešení TaskManager je vlajkovou lodí společnosti IT Park s.r.o. První myšlenka vznikla na základě praxe některých našich pracovníků v jiných organizacích. Při své práci pociťovali nedostatek možností pro <b>řízení efektivnosti</b> své práce či práce svých podřízených. Volali po nástroji pro <b>efektivní management úkolů</b>, který by byl <b>snadno propojitelný se zákazníky (a mohl tedy sloužit jako help desk), snadno se ovládal</b> a umožňoval <b>prioritizovat úkoly</b> - přesně v souladu s teorií a praxí <a href="{timeManagement}" title="time management III">time managementu III. generace</a>.
</p>

<p>
TaskManager již prošel celou řadou <a href="{changeLog}" title="aktualizace">aktualizací</a>, rozšíření a doplnění nových funkcí (a nová zlepšení stále připravujeme). V dnešní době se jedná o jedno z mála ryze českých řešení pro oblast tzv. <a href="{taskManagement}" title="task management">task managementu</a>, tedy řízení úkolů v souladu s <a href="{timeManagement}" title="time management III. generace">time managementem III. generace</a>.
</p>

<p>
V jakých oblastech může být řešení TaskManager Vaší pravou rukou?
</p>

<h2>Z manažerského pohledu:</h2>

<ul>
	<li>Při potřebě jednoduchým způsobem zadávat, plánovat a řídit úkoly (tasks) svých podřízených nebo členů realizačního či projektového týmu.</li>
	<li>Při potřebě mít přehled o vytíženosti a efektivitě jednotlivých pracovníků.</li>
	<li>Při potřebě mít přehled o stavu jednotlivých projektů, problémech, které projekty provází, o v projektu zainteresovaných pracovnících a jejich výkonech apod. Nástroj TaskManager je tak vhodný také jako podpůrné řešení pro projektové manažery.</li>
	<li>Při potřebě odhadnout potřebný čas a případné překážky pro dokončení úkolů směrem k vyššímu managementu či zákazníkům.</li>
	<li>Při potřebě využívat sdíleného kalendáře a upozorňovat hromadně na určité akce či události bez nutnosti rozesílat hromadné e-maily či svolávat informativní setkání.</li>
	<li>Při potřebě mít přehled o rozpracovanosti jednotlivých úkolů. (TaskManager v tomto případě nabízí přehledné grafické zpracování, které Vám již při letmém pohledu ukáže, jak na tom jednotlivé úkoly jsou.)</li>
	<li>Při potřebě podpořit vhodným softwarem zavedení <a href="{leanManagement}" title="lean management">lean managementu</a> ve Vaší společnosti, oddělení či projektovém týmu.</li>
</ul>

<h2>Z pohledu realizačních pracovníků:</h2>

<ul>
	<li>Při potřebě reportovat Vašim nadřízeným stav a výsledky Vaší práce co možná nejrychlejším a nejjednodušším způsobem, který Vás nebude zbytečně odvádět od další práce.</li>
	<li>Při potřebě mít přehled nad všemi projekty a zakázkami – a (především) nad úkoly, které z těchto zakázek pro Vás vyplývají.</li>
	<li>Při potřebě jednoduchým a efektivním způsobem přidělovat úkoly dalším pracovníkům.</li>
	<li>Při potřebě efektivně komunikovat s Vašimi klienty ohledně rozpracovaných zakázek.</li>
</ul>

<br />

<p>
Trvale sledujeme potřeby managementu i realizačních pracovníků v různých odvětvích a na základě těchto průzkumů řešení TaskManager upravujeme. <b>Naším cílem je, aby TaskManager byl tak flexibilní, jak flexibilní jste nebo potřebujete být Vy.</b>
</p>

<p> 
Máte-li zájem prohlédnout a vyzkoušet si prostředí řešení TaskManager, využijte <a href="{trialVersion}" title="registrační formulář">registrační formulář pro získání demoverze</a>.
</p>

<div class="links">
	<h2>Kam dál</h2>

	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="vlastnosti">Podívejte se na vlastnosti a přednosti řešení TaskManager</a></li>
		<li><a href="{functions}" title="funkce" >Podívejte se na přehled funkcí, díky kterým je TaskManager optimálním řešením pro malé i velké týmy</a></li>
		<li><a href="{references}" title="reference">Zjistěte, kdo již řešení TaskManager využívá</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o demoverzi</a></li>
	</ul>
</div>
';
}
