<?php
class CompanyTaskManagement_en{
	public $title = 'Managing tasks in company';
	public $description = 'Knowledge base: the essentials you are keen to know about task management in companies. ';
	public $keywords = 'TaskManager, manager task management time, task managemt in company, internal task management';

	public $text = '
<p>
There are many ways to solve business management tasks. We will introduce one of them - simple but highly efficient:<br />
<br />
<ol>
<li><b>Write down all tasks to TaskManager.</b> All of them. Really all. Ask your staff to do the same - to write down all the tasks they are aware of. Take pains over it and devote time to it, it will pay off. For simplicity or for individual tasks, you do not need to associate users who should process them. The important thing is that you will have all the tasks at one place. Just try to keep this simple point, each time a new task is created, write it to TaskManager. By following this first simple point, you will be able to keep everything in a clear position and you will be aware of all the tasks. At any time.
</li>

<li>
<img src="/tmpage/img/function/prioritizace.jpg" alt="prioritization" style="float:right;margin-left:10px">
<b>Prioritize.</b> If you already have all the jobs in one place, you usually find that it is more than you or your company can manage in a reasonable time. Therefore, prioritize. Ideally not alone, but to prioritize the (at least) managers. Prioritization in TaskManager is very simple and fast. Employees themselves will also be glad that their tasks will have clear priority.
</li>

<li><b>Automatize.</b> Observing point 1 (all the tasks in one place, i.e. creating tasks in TaskManager) also takes time (though relatively short). You often have repeated tasks (such as a monthly report to a customer, a VAT return every quarter, an annual report each year). You can just enter these tasks into TaskManager once and set them to repeat. They will then automatically be created exactly as if you were creating them manually (ie not only that task is created in TaskManager, but the employee will also receive an email notification).
</li>

<li><b>Have regular meetings about the status of tasks.</b> Weekly meetings where your employees are going through their tasks. At the meeting, ideally open the TaskManager (project it to the projector so everyone can see it) and go worker by worker (or team by team). Here, check the tasks and decide on the priorities for the workers who have the task to process and especially - allocate the new ones and set the deadlines for their completion.
</li>

<li><b>Do not allow tasks to "get stuck".</b> Tell your staff that as soon as anything stands in the way of completing their task, they are supposed to write it in a comment. Such a comment is also immediately sent to the assignor task (and eventually other task watchers) in order to complete the necessary information or remove the obstacle. Get two things right at the same time: you get information about the problem when performing the task right now (and you can solve it right away) and you will have all the relevant communication about the task in one place (in the task itself) you will not have the information scattered by emails.
</li>

<li><b><Create minimal substitutability.</b> Workers are leaving and coming. If not completely, they can leave temporarily due to illness, maternity, holiday, long-term official journey, and so on. Usually, when someone is to continue to solve the task, he must solve the problem of the lack of information about the work performed by the original worker. In this TaskManager is very helpful. It\'s no easier than finding all relevant information about the task, priorities, terms, comments and files directly in TaskManager. It gets him so quickly into the context so he can effectively proceed to what the previous / absent had not finished.
</p>
</li>
</ol>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="přednosti">Podívejte se, jaké možnosti Vám TaskManager může nabídnout</a></li>
		<li><a href="{functions}" title="funkce">Prohlédněte si funkce řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o zkušební verzi řešení TaskManager </a></li>
		<li><a href="{knowledgeBase}" title="znalostní báze">Prohlédněte si další články ve znalostní bázi</a></li>
	</ul>
</div>
';
}
