<?php
class Faq_cs{
	public $title = 'FAQ';
	public $description = 'Nejčastější dotazy k řešení TaskManager určenému pro řízení úkolů, time management či project management.';
	public $keywords = 'TaskManager, manager task management time, času řízení úkolů';

	public $text = '
<H2>1. Co je SaaS?</H2>
<P >SaaS je akronym
vyjadřující Software as a Service. Software nabízený pod tímto
typem licence si nemusíte kupovat. Je provozován na technickém
vybavení poskytovatele, který zpravidla zajišťuje veškeré
provozní záležitosti, stará se o aktualizaci systému apod.
Aplikace poskytované jako služba bývají často přístupné ze
sítě Internet. Máte tak výhodu, že bývají dostupné odkudkoli,
kde se lze připojit k&nbsp;internetu. Za takový software resp. za
poskytování takové služby zpravidla platíte paušální částku
(měsíční, čtvrtletní, roční). Tento systém má několik
výhod. Nejvýznamnější z&nbsp;nich je patrně fakt, že se
nemusíte starat o provoz software a zajišťovat si pracovníka
zodpovědného za jeho správu. Tyto záležitosti spadají do
kompetence poskytovatele software v&nbsp;režimu SaaS a Vy jen
software bez podobných starostí využíváte.</P>

<H2>2. Jaké jsou rozdíly mezi uživatelským a administrátorským účtem?</H2>
<P >Administrátorský účet,
jak již jeho název napovídá, slouží především k&nbsp;administraci
aplikace a řízení práv ostatních uživatelů, kteří k&nbsp;aplikaci
mají přístup. Má proto několik nástrojů, které běžným
uživatelům nejsou dostupné, jako například: 
</P>
<UL style="margin:10px;">
	<LI>nastavování práv
	uživatelů ve vztahu k&nbsp;aplikaci TaskManager, 
	<LI>nastavování práv
	uživatelů ve vztahu k&nbsp;jednotlivým projektům,
	<LI>správa zdrojů
	dostupných v&nbsp;aplikaci,
	<LI>nastavení určitých
	atributů chování systému,
	<LI>kontrola odeslaných
	urgenčních sms zpráv,
	<LI>správa typů úkolů
	apod.
</UL>
<P >Ovládání těchto
funkcí je náročnější, než pouhé užívání aplikace běžným
uživatelem. Proto jsme pro účely kvalitního zaškolení
administrátorů připravili specializované <a href="{adminTraining}">školení
pro administrátory aplikace TaskManager</a>. Dostupné je i <a href="{userTraining}">školení
pro běžné uživatele aplikace TaskManager</a>, kde se naučíte
pracovat s&nbsp;těmi částmi, které jsou určené především
uživatelům, jako je správa úkolů, statistiky výkonnosti,
reporting apod.</P>
<H2>3. V&nbsp;čem je řešení TaskManager jedinečné?</H2>
<P >Řešení TaskManager má
několik předností, které jej významně odlišují od
konkurenčních produktů. Jedná se především o tyto vlastnosti:</P>
<UL style="margin:10px;">
	<LI>Všechny důležité
	funkce jsou implementovány na jednom místě, v&nbsp;jedné
	aplikaci. Nemusíte tak používat pět různých programů, abyste
	mohli efektivně spravovat svůj pracovní výkon. 
	<LI>TaskManager
	obsahuje time tracker pro měření odpracovaného času. Nemusíte
	tak opět používat jakékoli externí aplikace. TaskManager Vám
	umožní změřit odpracovaný čas a ten následně vykázat
	v&nbsp;reportech.
	<LI>Aplikace TaskManager je multiplatformní. Díky přístupu přes webové
	rozhraní, se k&nbsp;němu můžete připojit na všech běžně
	dostupných zařízeních, jako jsou PC, notebooky, tablety,
	smartphones a také některé běžné  mobilní telefony obsahující
	mobilní internetové prohlížeče.
	<LI>Aplikace TaskManager disponuje přívětivým a intuitivním uživatelským
	prostředím, které zvládne používat skutečně každý. Při
	jeho vývoji jsme s&nbsp;maximálním důrazem dbali na použitelnost
	a maximálně jednoduché ovládání. Nemusíte tak ztrácet čas
	„bojem“ s&nbsp;aplikací nebo některou z&nbsp;jejích funkcí a
	můžete TaskManager využívat naplno.
</UL>

<H2>4. Jak mohu řešení objednat?</H2>
<P >V&nbsp;případě, že
máte zájem o prezentaci řešení TaskManager, nebo jej chcete
přímo objednat, kontaktujte nás na e-mailové adrese
<A HREF="mailto:obchod@itpark.cz">obchod@itpark.cz</A>, případně
vyplňte <a href="{contacts}">kontaktní formulář</a>
. V&nbsp;případě, že
využijete e-mailové adresy <A HREF="mailto:obchod@itpark.cz">obchod@itpark.cz</A>,
uveďte prosím do textu e-mailu také telefonický kontakt na Vás,
abychom Vás pro urychlení komunikace mohli kontaktovat telefonicky.</P>

<H2>5. Jak mohu kontaktovat podporu?</H2>
<P>Jste-li naším klientem,
uživatelem řešení TaskManager, byli jste zcela jistě
informováni o e-mailových adresách či telefonních číslech pro
kontaktování podpory. Vaše možnosti pro kontakt s&nbsp;technickou
podporou také závisí na tom, jakou variantu přístupu k&nbsp;podpoře
(helpdesku) máte předplacenou. Pokud tyto kontakty nemáte po ruce,
můžete vždy využít <a href="http://taskmanager.cz/helpdesk/">online helpdesk</a>.</P>

<H2>6. Pro jaké obory podnikání se
řešení TaskManager nejvíce hodí?</H2>
<P >TaskManager je
multioborové řešení, které nalezne uplatnění jak ve sféře
služeb, tak ve výrobních podnicích. Jednoduchým kritériem je
fakt, zda jednotlivé organizační úrovně Vaší společnosti
spolu potřebují efektivně komunikovat a zadávat si úkoly
způsobem, který umožní sledovat jejich plnění a vyhodnocovat
efektivitu práce. Pokud je tato podmínka splněna, pak je TaskManager tím pravým řešením pro Vás.</P>

<H2 >7. Jaké jsou požadavky na technické vybavení, chci-li si koupit licenci řešení TaskManager?</H2>
<P >
TaskManager si lze pořídit dvěma způsoby. Buď formou SaaS (Software jako služba), kdy se o technické vybavení počítače
nebo serveru vůbec nemusíte starat (automaticky škálujeme HW serverů tak, aby vyhovoval vysokým požadavkům našich klientů) nebo
si můžete pořídit licenci TaskManageru - v tomto případě je nainstalován přímo na server do Vaší firmy. V tomto případě je ovšem
nutné zajistit, že parametry takového serveru budou dostačující pro plynulý chod TaskManageru. Nároky na server se liší dle
počtu uživatelů, kteří s TaskManagerem pracují. Následující tabulka obsahuje doporučený hardware pro různé počty uživatelů:</P>
<br />
<table style="border-width:1px; border-style:solid; border-color:#888; margin-left:20px; margin-right:20px;">
	<tr>
		<th style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">Počet uživatelů</th>
		<th style="border-width:0px 0px 1px 0px; border-style:solid; border-color:#888; padding:4px;">doporučená HW konfigurace serveru</th>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 5
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Celeron 2.6GHz<br />
			Paměť: 2 GB<br />
			HDD: 7200rpm disk<br />
			Síťové připojení serveru: alespoň 10Mbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 25
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Core 2 Q9650 Quad Core, 3GHz, 1333FSB, 12MB cache<br />
			Paměť: 4 GB<br />
			HDD: 7200rpm disk<br />
			Síťové připojení serveru: alespoň 100Mbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 1px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 100
		</td>
		<td style="border-bottom:1px solid #888; padding:4px;">
			CPU: Intel Core 2 Q9650 Quad Core, 3GHz, 1333FSB, 12MB cache<br />
			Paměť: 4 GB<br />
			HDD: 10000rpm disk nebo SSD disk<br />
			Síťové připojení serveru: 1Gbit
		<td>
	</tr>
	<tr>
		<td style="border-width:0px 1px 0px 0px; border-style:solid; border-color:#888; padding:4px;">
			do 1000
		</td>
		<td style="padding:4px;">
			Pro prostředí s takto velkým počtem uživatelů doporučujeme nasadit TaskManager na mid-range server typu
			HP Proliant, např. (Dvouprocesorový server HP ProLiant DL360G7 rack 1U, Quad-Core Intel Xeon E5630, RAM 6GB DDR3, Bez HDD, RAID (0/1/1+0/5/5+0))<br />
			Síťové připojení serveru: 1Gbit
		<td>
	</tr>
</table>
<br />

<H2>8. Covyjadřuje zkratka LDAP/AD?</H2>
<P >
LDAP znamená Lightweight Directory Access Protocol. Je to protokol, který se používá pro ukládání
uživatelů a jejich dat (jméno, příjmení, login, heslo, e-mail, číslo přístupové karty,..). Zjednodušeně si můžeme
představit, že se jedná o takový telefonní seznam, který kromě jména uživatele eviduje i další údaje jako například
login a heslo. Toho dokáže TaskManager využívat v tom smyslu, že v něm není potřeba vytvářet nové uživatele, ale
stačí jej nakonfigurovat tak, aby uživatele ověřoval vůči LDAPu a pak jakákoliv změna, která je vykonána v LDAPu
je ihned promítnuta do TaskManagera.<br />
AD znamená Active Directory je to implementace adresářových služeb LDAP firmou Microsoft.
</P>

<H2>9. Kolik uživatelů může
používat řešení TaskManager, zakoupím-li licenci?</H2>
<P ><B>Licence řešení Task
Manager není omezená počtem uživatelů.</B> Jediným faktorem,
který determinuje počet uživatelů, je výkonnost Vašeho
technického vybavení, na kterém bude TaskManager spuštěn. Je
třeba mít na paměti, že s&nbsp;velkým počtem uživatelů rostou
nároky řešení TaskManager na hardwarové vybavení. 
</P>
<H2>10. Je nutné pro tvorbu nových
úkolů vždy vstupovat do aplikace TaskManager?</H2>
<P>Není.
Pro zadávání úkolů v&nbsp;aplikaci TaskManager stačí, když
pošlete e-mailovou zprávu ve vhodném tvaru. Tímto způsobem
můžete k&nbsp;vytvářeným úkolům přikládat také přílohy,
které se v&nbsp;aplikaci TaskManager uloží. Vzhledem k&nbsp;tomu,
že e-mailového klienta má dnes již také většina mobilních
telefonů, nejste při zadávání úkolů prakticky vázáni
dostupnou výpočetní technikou. 
</P>

<H2>11. Lze úkol v TaskManageru odmítnout?</H2>
<P>
Odmítnutí úkolu se většinou děje tak, ze pracovník, který dostane úkol k řešení jej okomentuje (negativně) a buďto přesune do skupiny ukolů <i>Hotové</i>,
nebo je vytvořena administrátorem nová skupina <i>Odmítnuté</i> a pracovník přesune úkol do této skupiny. Zadavateli samozřejmě přichází jak při změně skupiny úkolu, tak
při napsání komentáře k úkolu e-mailová notifikace, takže se o tom dozví a může dále jednat.
</P>

<H2>12. Jak pracujete s čekajícími úkoly?</H2>
<P>
Čekající úkoly jsou dosud neaktivní úkoly a úkoly z nějakého důvodu pozastavené. Praxe ukazuje, ze přestože zadavatel zadá pracovníkovi nějaký úkol a ten jej zčásti splní,
tak k úplnému splnění např. potřebuje spolupráci s další stranou (např. se zákazníkem - pracovník si po něm vyžádá více informací a čeká na ně), proto se v tomto
případě, kdy pracovník čeká na nějakou další stranu typicky úkol přesunuje do této skupiny, ať tam pracovníkovi ve skupině <i>Nové</i> "nezavazí" a může pokračovat
dalším úkolem.
</P>

<H2>13. Jak probíhá akceptace splněného úkolu zadavatelem?</H2>
<P>
Toto se typicky děje tak, že pracovník úkol ukončí, napíše např. nějaký komentář s řešením nebo přiloží soubor s řešením, apod. a přesune úkol do skupiny <i>Hotové</i>.
Zadavatel je o tom informován e-mailem (s přímým odkazem na úkol) a výstup úkolu si přebírá/kontroluje. Pokud se mu výstup nelíbí nebo s ním nesouhlasí, jednoduše může
přidat komentář a úkol přesunout zpět do nových úkolů a tím se pracovníkovi opět zařadí do fronty jeho úkolů (pracovník o tom opět obdrží e-mailovou notifikaci).
</P>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{aboutProduct}" title="o produktu">Podívejte se na základní informace o řešení TaskManager</a></li>
		<li><a href="{features}" title="přednosti">Prohlédněte si přednosti řešení TaskManager</a></li>
		<li><a href="{functions}" title="funkce">Zjistěte více informací o funkcích řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o demoverzi</a></li>
	</ul>
</div>

';
}
