<?php
class LeanManagement_cs{
	public $title = 'Lean Management';
	public $description = 'Znalostní báze: to nejdůležitější, co by Vás mohlo zajímat o lean managementu neboli štíhlém řízení.';
	public $keywords = 'TaskManager, manager task management time, lean management štíhlý';

	public $text = '
<p align="justify">
<strong>Lean management</strong> (<strong>štíhlé řízení</strong>) bychom mohli definovat jako způsob práce či filosofii, která si klade za cíl zvyšovat přidanou
hodnotu veškerých firemních činností pro zákazníka a zároveň snižovat úroveň plýtvání zdroji, ať už se jedná o finanční prostředky, lidskou práci, čas, materiál či
například skladové prostory. 
Jeho cílem je snížit zbytečné a neproduktivní plýtvání všemi zdroji na minimum, čímž se může buď zvýšit přidaná hodnota pro zákazníka, nebo snížit jeho náklady.
Lean management (štíhlé řízení) lze uplatnit jak ve výrobě, tak v administrativních odděleních. Některé zprávy hovoří dokonce o využití na úrovni měst a státních orgánů.
V této oblasti štíhlé řízení používáno především v cizině. Zajímavé zprávy o aplikaci lean managementu ve státní správě jsou například z některých amerických městských správ.
</p>

<p>
<strong>Lean management</strong> vychází z pěti hlavních principů, kterými jsou 
<ol>
<li>Stanovte to, co má pro zákazníka skutečnou hodnotu.</li>
<li>Identifikujte tok hodnoty.</li>
<li>Vytvořte plynulé a nepřerušované procesy.</li>
<li>Vytvořte systémy řízené potřebou (tzv. princip tahu).</li>
<li>Neustále se snažte o dokonalost.</li>
</ol>
</p>

<p>
<strong>Lean management</strong> zahrnuje několik klíčových kroků, a to:
<ol>
<li><strong>Lean plánování</strong> – jasné a transparentní strategické řízení 
<li><strong>Lean procesy managementu</strong> – jednoznačný a přehledný management procesů 
<li><strong>Lean dokumentovaný systém</strong> – jednoduché a přehledné dokumenty 
<li><strong>Lean obchodní procesy</strong> – štíhlý tok, redukce plýtvání v procesech a neustálé zlepšování 
<li><strong>Lean implementace</strong> – uspořádaný a disciplinovaný systém vedení, který zajišťuje to, že strategie budou implementovány a cíle budou dosaženy (<strong>Lean Culture</strong>)
</ol>
</p>

<p>
S <strong>lean managementem</strong> velmi úzce souvisí také systém trvalého zlepšování <strong>Kaizen</strong> a systém účelného hospodaření na pracovišti, který je
všeobecně znám jako <strong>5S</strong>. Oba systémy se rozšířily z Japonska, kde mají poměrně dlouhou tradici. 5S jako název vznikl z pěti japonských slov, které všechny
začínají na „S“. Jsou to: 
<ol>
<li>Seiri, což bychom mohli přeložit jako separovat.</li>
<li>Seiton – do češtiny volně přeloženo jako systematizovat.</li>
<li>Seiso – v češtině stále (trvale) čistit.</li>
<li>Seiketsu – v češtině standardizovat.</li>
<li>Shitsuke – do češtiny přeloženo jako snaha o stálost – sebedisciplína.</li>
</ol>
I systém 5S i Kaizen lze využívat nejen ve výrobních odděleních či závodech, ale své místo naleznou i v administrativě.
</p>

<p>
Jak Vám může <strong>TaskManager</strong> pomoci při implementaci <strong>štíhlého řízení</strong> ( <strong>lean managementu</strong>)?
<ul>
<li>TaskManager Vám pomůže odhalit úkony a procesy, které jsou vykonávány buď zcela zbytečně, nebo špatnými pracovníky. Příkladem může být zbytečná administrativní zátěž vysoce specializovaných a drahých pracovníků, kdy administrativu lze přenechat levnějším administrativním pracovníkům (asistentům apod.).</li>
<li>TaskManager Vám pomůže rozeznat, jaké činnosti vykonávají Vaši pracovníci. Díky této analýze budete schopni určit, zda Vaši pracovníci pracují efektivně, nebo zda lze mix jejich činností a kompetencí upravit tak, aby byly jejich možnosti plně využity.</li>
<li>TaskManager Vám pomůže identifikovat procesy a úkony, které mají minimální dopad na uspokojení zákaznických požadavků a zároveň překážky, které k takovému nedostatečnému uspokojení vedly. Například budete schopni odhalit dlouhé prostoje v komunikaci u pracovníků, kteří jsou v kontaktu s Vašimi zákazníky, nebo například pomalou odezvu pracovníků realizujících konkrétní úkol pro Vaše zákazníky apod.</li>
</ul>
Neváhejte a zjistěte, jak můžete TaskManager využít při zavádění lean managementu ve Vaší firmě. <a href="{trialVersion}">Zažádejte si o měsíční zkušební verzi zdarma</a>. 
</p>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="přednosti">Podívejte se, jaké možnosti Vám TaskManager může nabídnout</a></li>
		<li><a href="{functions}" title="funkce">Prohlédněte si funkce řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o zkušební verzi řešení TaskManager </a></li>
		<li><a href="{knowledgeBase}" title="znalostní báze">Prohlédněte si další články ve znalostní bázi</a></li>
	</ul>
</div>
';
}
