<?php
class TimeManagement_cs{
	public $title = 'Time Management';
	public $description = 'Znalostní báze: to nejdůležitější, co by Vás mohlo zajímat o time managementu neboli řízení času.';
	public $keywords = 'TaskManager, manager task management time, řízení času, timemanagement';

	public $text = '
<p>
Time managementem (neboli řízením času) bývají nazývány aktivity vedoucí k efektivněji využívanému času. Lze je využívat jak pro pracovní, tak pro soukromý čas, i když hlavní uplatnění mají samozřejmě ve sféře pracovní. Cíle těchto aktivit obecně závisí na generaci time managementu, kterou dotyčný jedinec používá. Všeobecně ovšem můžeme říci, že hlavním cílem aktivit spadajících do sféry time managementu je snaha maximalizovat užitek z každé časové jednotky. Generace řízení času rozeznáváme celkem 4. Liší se od sebe především používanými nástroji a také tím, jaké aspekty úkolu uživatele toho kterého systému řízení času zajímají. 
</p>
	
	
<h2>Time management 1. generace</h2>
<p>
Time management 1. generace, jak již název napovídá, je první filosofií, která se řízením času systematicky zabývá. 1. generace řízení času je charakteristická používáním tzv. To-Do listů, tedy jednoduchých zápisníků, do nichž se zapisovaly úkoly. Neuváděl se u nich ani požadovaný termín dokončení, ani priorita, s níž je třeba úkoly řešit.
</p>
<p>
Důvodem vzniku a využívání řízení času 1. generace byla potřeba nezapomínat větší množství úkolů a mít jednoduchý přehled o tom, které úkoly jsou a které nejsou dokončeny. Při dokončení jakéhokoli úkolu se tento jednoduše označil či například škrtl, aby bylo jasně rozeznatelné, které úkoly jsou dokončeny a kterým je třeba se ještě věnovat.
1. generace řízení času měla nespornou výhodu ve své maximální jednoduchosti, která snad ani nemůže být překonána. Nevýhodou ovšem je nepoužívání ani data dokončení, ani prioritizace jednotlivých úkolů. Tyto nevýhody z něj dnes pro pracovní život dělají prakticky nepoužitelný nástroj.
</p>

<h2>Time management 2. generace</h2>
<p>
Postupem času bylo třeba k jednotlivým úkolům zaznamenávat požadované nejzazší termíny dokončení, což vedlo ke vzniku řízení času 2. generace a vzniku jednoduchých diářů a pracovních kalendářů.
</p>
<p>
Tato generace znamenala velký posun kupředu v oblasti plánování času, protože svým uživatelům umožňovala předvídat vytíženost v jednotlivých dnech a také plnit úkoly v termínech, které byly pro jejich zadavatele relevantní. 
Nicméně stále ještě mohl nastávat zmatek v případě více významných událostí v jednom dni, kdy najednou uživatel systému řízení času 2. generace musel rozhodnout, které aktivity budou upřednostněny a kterým se bude věnovat později. Tak se objevil požadavek na prioritizaci úkolů, který dal vzniknout řízení času 3. generace.
</p>

<h2>Time management 3. generace</h2>
<p>
Systémy plánování času 3. generace jsou dnes nejrozšířenějšími systémy v pracovní sféře, zvláště pak v takových profesích, jako jsou IT vývojáři a vývojové týmy, řídicí pracovníci, živnostníci a majitelé firem (CEOs), advokáti, konzultanti a mnoho dalších. 
</p>
<p>
Vzešel ze systémů pro řízení času 2. generace, když tyto systémy byly doplněny o možnost prioritizovat jednotlivé úkoly. Tak se mohli uživatelé systému řízení času 3. generace plně rozhodovat, které úkoly mají přednost. Jednotlivé úkoly následně označili například čísly nebo písmeny ABC (Systém prioritizace ABC), díky čemuž při letmém přehledu svých aktivit hned věděli, které úkoly je třeba řešit nejdříve.
</p>

<h2>Time management 4. generace</h2>
<p>
Na úvod je třeba říci, že time management 4. generace se od svých předchůdců svou filosofií značně liší. Více než o systém řízení času se jedná o komplexní nástroj pro dlouhodobé řízení života (life management). Co tento systém přidal nového ke svým předchůdcům, se dozvíte v následujícím článku.
</p>
<p>
Autorem time managementu 4. generace je uznávaný americký podnikatel, mentor a konzultant Stephen Covey, jenž je v České republice znám především jako autor knihy 7 návyků skutečně efektivních lidí. 
</p>
<p>
Jak jsme již řekli výše, jedná se spíše o filosofii a systém řízení života (life management), než o klasické řízení času. Tak jako všechny předchozí generace time managementu vždy přidaly něco ke svému předchůdci, činí tak i 4. generace. Ta se tedy skládá z klasického řízení času 3. generace (sepisování úkolů s termíny a prioritami). Je ale doplněna o klíčovou složku mapující život a životní cíle svého uživatele, jeho poslání, dlouhodobá přání apod. Systémy řízení času 4. generace jsou tedy navrženy tak, aby svým uživatelům pomáhaly určit, co je pro ně v životě skutečně důležité a těmto cílům podřídily vše ostatní včetně plánování času.
V systémech řízení času 4. generace se jako standardní časová jednotka užívá týden. Plánuje se tedy v týdenních cyklech, a to vždy před jejich započetím. Díky tomu lze dostatečně reflektovat skutečné životní hodnoty a dlouhodobé cíle, které tak dostanou při plánování přednost. Ostatní čas, který po plánování zbude, lze vyplnit akutními událostmi, případě volnočasovými aktivitami apod. 
</p>
<p>
Systém řízení 4. generace vychází z Matice řízení času navržené také Stephenem Coveyem. Ta rozděluje jednotlivé úkoly podle dvou kritérií, a to podle urgentnosti a důležitosti. Covey uvádí, že nejdůležitějším segmentem je segment druhý, který sdružuje události důležité, ale neurgentní – tedy události strategického významu. Do prvního segmentu řadíme události, které jsou důležité a navíc urgentní, do třetí urgentní ale nedůležité a do čtvrté nedůležité a neurgentní. Důvodem, proč není nejdůležitější segment 1, je fakt, že ti, kdo kladou důraz právě na tento segment, jsou ve vleku událostí a nemají možnost plně řídit svůj život a dlouhodobý rozvoj. Řeší tedy spíše krátkodobé taktické úkoly a záležitosti místo aby se věnovali úkolům, které pro ně mají dlouhodobý – strategický význam.
</p>
<p>
Důvod, proč time management 4. generace ještě není příliš rozšířený (alespoň v ČR ne), je fakt, že vyžaduje značnou změnu osobních paradigmat a způsobu myšlení svých uživatelů. A takový způsob osobního rozvoje, jak všichni víme, nepatří zrovna mezi oblíbené.
</p>

<div class="links">
	<h2>Kam dál</h2>
	<a href="{trialVersion}" class="floatRight" title="demo verze">
	<img alt="banner" src="/tmpage/img/bannermini.jpg">
	</a>

	<ul>
		<li><a href="{features}" title="přednosti">Podívejte se, jaké možnosti Vám TaskManager může nabídnout</a></li>
		<li><a href="{functions}" title="funkce">Prohlédněte si funkce řešení TaskManager</a></li>
		<li><a href="{trialVersion}" title="demoverze">Zažádejte si o zkušební verzi řešení TaskManager </a></li>
		<li><a href="{knowledgeBase}" title="znalostní báze">Prohlédněte si další články ve znalostní bázi</a></li>
	</ul>
</div>
';
}
